(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6048,        166]*)
(*NotebookOutlinePosition[      6748,        190]*)
(*  CellTagsIndexPosition[      6704,        186]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(Off[General::spell1]\)], "Input"],

Cell[BoxData[
    \(<< Graphics`ComplexMap`\)], "Input"],

Cell[BoxData[
    \(\(\(\(Needs["\<Graphics`Colors`\>"]\) \)\(;\)\(\ \ \)\( (*para\ usar\ \
colores\ con\ comodidad*) \)\(\n\)\(\(Off[
        General::spell1]\) \)\(;\)\(\ \ \)\(\n\)\( (*para\ que\ Mathematica\ \
no\ nos\ moleste\ con\ avisos\ de\ error\ en\ los\ nombres\ de\ los\ comandos*) \
\)\)\)], "Input"],

Cell[BoxData[
    \(\(f[x_, y_] = 1 + x^2 + y^2;\)\)], "Input"],

Cell[BoxData[
    \(\(averg1 = \(averg2 = Range[0 + 0.1/2, 1 - 0.1/2, 0.1]\);\)\)], "Input"],

Cell[BoxData[
    \(\(graf1 = 
        CartesianMap[
          Identity, \ {0, 1, 0.1}, {0, 1, 
            0.1}, \[IndentingNewLine]Ticks \[Rule] {Range[0, 1,  .1], 
              Range[0, 1,  .1]}, AxesLabel \[Rule] {"\<x\>", "\<y\>"}, 
          PlotStyle \[Rule] {Blue, Red}, 
          Epilog \[Rule] {PointSize[0.015], Hue[1], 
              Flatten[Outer[Point, averg1, averg2] /. 
                  Point[x_, y_] \[Rule] Point[{x, y}]]}];\)\)], "Input"],

Cell[BoxData[
    \(\(sumariemann2D[f_, {x_, xmin_, xmax_}, {y_, ymin_, ymax_}, m_, n_, 
          prec_:  $MachinePrecision] := 
        Module[{incx, incy, particionx, particiony, valoresf}, \n\t\tincx = 
            N[\((xmax - xmin)\)/m, prec]; \n\t\tincy = 
            N[\((ymax - ymin)\)/n, prec]; \n\t\tparticionx = 
            Table[xmin + incx/2 + k*incx, {k, 0, 
                m - 1}]; \[IndentingNewLine] (*\ 
            particionx = 
              Range[xmin + incx/2, xmax - incx/2, 
                incx]\ *) \n\t\tparticiony = 
            Table[ymin + incy/2 + q*incy, {q, 0, n - 1}]; \n\t\tvaloresf = 
            If[FreeQ[f, x] && FreeQ[f, y], 
              Flatten[Outer[f, particionx, particiony]], 
              Flatten[Outer[\((f /. {x -> #1, y -> #2})\) &, particionx, 
                  particiony]]]; \n\t\t\((Plus @@ valoresf)\)*incx*
            incy];\)\)], "Input"],

Cell[BoxData[
    \(sumariemann2D[1 + x^2 + y^2, {x, 0, 1}, {y, 1, 2}, 100, 100]\)], "Input"],

Cell[BoxData[
    \(sumariemann2D[f, {x, 0, 1}, {y, 1, 2}, 100, 100]\)], "Input"],

Cell[BoxData[{
    \(\(\(Integrate[f[x, y], {x, 0, 1}, {y, 1, 2}]\)\(\n\)
    \)\), "\n", 
    \(% // N\)}], "Input"],

Cell[BoxData[
    \(\(sumariemann2Dset[set_, f_, {x_, xmin_, xmax_}, {y_, ymin_, ymax_}, 
          m_, n_, prec_:  $MachinePrecision] := 
        Module[{incx, incy, particionx, particiony, valoresf}, \n\t\tincx = 
            N[\((xmax - xmin)\)/m, prec]; \n\t\tincy = 
            N[\((ymax - ymin)\)/n, prec]; \n\t\tparticionx = 
            Table[xmin + incx/2 + k*incx, {k, 0, 
                m - 1}]; \[IndentingNewLine] (*\ 
            particionx = 
              Range[xmin + incx/2, xmax - incx/2, 
                incx]\ *) \n\t\tparticiony = 
            Table[ymin + incy/2 + q*incy, {q, 0, n - 1}]; \n\t\tvaloresf = 
            If[FreeQ[f, x] && FreeQ[f, y], 
              Flatten[Outer[If[set[#1, #2], f[#1, #2], 0] &, particionx, 
                  particiony]], 
              Flatten[Outer[If[set[#1, #2], f /. {x -> #1, y -> #2}, 0] &, 
                  particionx, particiony]]]; \n\t\t\((Plus @@ valoresf)\)*
            incx*incy];\)\)], "Input"],

Cell[BoxData[
    \(\(conjunto[x_, y_] := x^2 + y^2 < 1;\)\)], "Input"],

Cell[BoxData[
    \(sumariemann2Dset[conjunto, f, {x, \(-1\), 1}, {y, \(-1\), 1}, 100, 
      100]\)], "Input"],

Cell[BoxData[
    \(sumariemann2Dset[conjunto, f[x, y], {x, \(-1\), 1}, {y, \(-1\), 1}, 
      100, 100]\)], "Input"],

Cell[BoxData[
    \(Integrate[
      1 + x^2 + y^2, {x, \(-1\), 
        1}, {y, \(-\@\(1 - x^2\)\), \@\(1 - x^2\)}]\)], "Input"],

Cell[BoxData[
    \(% // N\)], "Input"],

Cell[BoxData[
    \(\(Show[graf1, Graphics[Circle[{ .5,  .5},  .5]]];\)\)], "Input"],

Cell[BoxData[
    \(\(set[x_, y_] := 
        0 \[LessEqual] x \[LessEqual] 
            1\  && \  .5 - Sqrt[ .25 - \((x -  .5)\)^2] \[LessEqual] 
            y \[LessEqual] \  .5 + Sqrt[ .25 - \((x -  .5)\)^2];\)\)], "Input"],

Cell[BoxData[
    \(sumariemann2Dset[set, f, {x, 0, 1}, {y, 0, 1}, 50, 50]\)], "Input"],

Cell[BoxData[
    \(Integrate[
      f[x, y], {x, 0, 
        1}, {y,  .5 - Sqrt[ .25 - \((x -  .5)\)^2],  .5 + 
          Sqrt[ .25 - \((x -  .5)\)^2]}]\)], "Input"]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 53, 1, 72, "Input"],
Cell[1810, 54, 56, 1, 72, "Input"],
Cell[1869, 57, 313, 5, 150, "Input"],
Cell[2185, 64, 63, 1, 72, "Input"],
Cell[2251, 67, 92, 1, 72, "Input"],
Cell[2346, 70, 461, 9, 176, "Input"],
Cell[2810, 81, 901, 16, 358, "Input"],
Cell[3714, 99, 93, 1, 72, "Input"],
Cell[3810, 102, 81, 1, 72, "Input"],
Cell[3894, 105, 117, 3, 124, "Input"],
Cell[4014, 110, 973, 17, 384, "Input"],
Cell[4990, 129, 71, 1, 72, "Input"],
Cell[5064, 132, 111, 2, 72, "Input"],
Cell[5178, 136, 117, 2, 72, "Input"],
Cell[5298, 140, 129, 3, 79, "Input"],
Cell[5430, 145, 39, 1, 72, "Input"],
Cell[5472, 148, 84, 1, 94, "Input"],
Cell[5559, 151, 226, 4, 94, "Input"],
Cell[5788, 157, 87, 1, 94, "Input"],
Cell[5878, 160, 166, 4, 120, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

